% X: Array of position X
% Y: Array of position Y
% rf: Exterior radius
% t: thickness of the cuts
%

function [cuts,isGroove,PadPlane] = FindCuts(X,Y,Z,t)
if nargin < 4
    t = 1.5;
end
% PadPlane = zeros(6,3);

x1_groove = -8.55502;
y1_groove = -12.9252;
x2_groove = -15.5337;
y2_groove = -26.2661;

m1_groove = (y2_groove-y1_groove)/(x2_groove-x1_groove);
b1_groove = y1_groove - m1_groove*x1_groove;
func1_groove = @(x) m1_groove*x + b1_groove;

x_cut1 = -3.0637;
x_cut1f = -4.5105;
y_cut1 = -15.1942;
y_cut1f = -30.1804;

[theta1,r1] = cart2pol(x_cut1,y_cut1);
delta_theta_cut = atan(t/r1);
[x_cut1_2,y_cut1_2] = pol2cart(theta1-delta_theta_cut,r1); 
rf = max(X(1,:));
[x_cut1_2f,~] = pol2cart(theta1-delta_theta_cut,rf); 

m1 = (y_cut1f-y_cut1)/(x_cut1f-x_cut1);
b1 = y_cut1-m1*x_cut1;
b2 = y_cut1_2-m1*x_cut1_2;

func1_1 = @(x) m1*x+b1;
func1_2 = @(x) m1*x+b2;

xv = [x_cut1*0.9;x_cut1f*1.1;x_cut1_2f;x_cut1_2*0.9;x_cut1*0.9];
yv = [func1_1(xv(1:2));func1_2(xv(3:4));func1_1(xv(end))];
cuts = inpolygon(X,Y,xv,yv);

xv_groove = xv;xv_groove([1 2 5]) = [x1_groove*0.9 x2_groove*1.3 x1_groove*0.9];
yv_groove = yv;yv_groove([1 2 5]) = func1_groove(xv_groove([1 2 5]));
isGroove = inpolygon(X,Y,xv_groove,yv_groove);

for iAngle = 1:5
    [theta_r,r_r] = cart2pol(xv,yv);
    theta_r = theta_r + pi/3;
    [xv,yv] = pol2cart(theta_r,r_r);
    cuts = cuts | inpolygon(X,Y,xv,yv);

    [theta_groove,r_groove] = cart2pol(xv_groove,yv_groove);
    theta_groove = theta_groove + pi/3;
    [xv_groove,yv_groove] = pol2cart(theta_groove,r_groove);
    isGroove = isGroove | inpolygon(X,Y,xv_groove,yv_groove);
end
isGroove(cuts)=false;

for iPad = 1:5
    file_start = 566 + 600*(iPad-1);
    file_end = 790 + 600*(iPad-1);
    pad_block = isGroove;
    pad_block([1:file_start-1 file_end+1:end],:) = false;
    [xData, yData, zData] = prepareSurfaceData( X(pad_block), Y(pad_block), Z(pad_block) );
    ft = fittype( 'poly11' );
    [fitresult, ~] = fit( [xData, yData], zData, ft );
    PadPlane.(sprintf('pad%d',iPad)).plane = [fitresult.p10 fitresult.p01 fitresult.p00];
    PadPlane.(sprintf('pad%d',iPad)).points = pad_block;
    PadPlane.(sprintf('pad%d',iPad)).pos = [file_start file_start+164 file_end-194 file_end];
end

pad_block = isGroove;
pad_block(191:3565,:) = false;
[xData, yData, zData] = prepareSurfaceData( X(pad_block), Y(pad_block), Z(pad_block) );
ft = fittype( 'poly11' );
[fitresult, ~] = fit( [xData, yData], zData, ft );
PadPlane.pad6.plane = [fitresult.p10 fitresult.p01 fitresult.p00];
PadPlane.pad6.points = pad_block;
PadPlane.pad6.pos = [file_start+600 131 3596 189];

for iPad=2:6
    PadPlane.(sprintf('pad%d',iPad)).full = false(size(isGroove));
    for j=1:32
        val = find(PadPlane.(sprintf('pad%d',iPad-1)).points(:,j));
        val1 = val(1);
        val = find(PadPlane.(sprintf('pad%d',iPad)).points(:,j));
        val2 = val(end);
        PadPlane.(sprintf('pad%d',iPad)).full(val1:val2,j) = 1;
    end
    PadPlane.(sprintf('pad%d',iPad)).full = PadPlane.(sprintf('pad%d',iPad)).full & (~PadPlane.(sprintf('pad%d',iPad-1)).points);
end
PadPlane.pad6.full = PadPlane.pad6.full | PadPlane.pad6.points;

PadPlane.pad1.full = false(size(isGroove));
for j=1:32
        % val = find(PadPlane.pad6.points(1:200,j));
        val1 = 1;
        val = find(PadPlane.pad1.points(:,j));
        val2 = val(end);
        PadPlane.pad1.full(val1:val2,j) = 1;
end
pad_aux = PadPlane.pad6.points;
pad_aux(200:end,:) = false;
PadPlane.pad1.full = PadPlane.pad1.full & (~pad_aux);

end